## Code of Conduct

A primary goal of the RedMew community is to be inclusive to the largest number of people, with the most varied and diverse backgrounds possible. As such, we are committed to providing a friendly, safe and welcoming environment for all, regardless of gender, sexual orientation, ability, ethnicity, socioeconomic status, and religion (or lack thereof).

### Reporting bugs and opening issues

Please report bugs and open issues generously. Don't be afraid that your idea is silly, or you're reporting a duplicate issue. We're happy to hear from you.

### Code and other contributions

Contributions to RedMew (via pull request or otherwise) *must* be licensed under the [GNU General Public License v3.0](LICENSE).

## Ways to contribute

**No technical expertise is required to contribute to RedMew**

There are many ways to contribute to RedMew. Some require technical expertise and others do not. If you're interested in contributing or want to know more, inquire in our [Discord][2].

### Developing RedMew

The RedMew source is a LUA scenario for Factorio. It includes code that creates GUI elements, adds gameplay elements, and generates maps. These tools can always use refinement and improvement.

The [issues][1] list is a good place to start.

### Helping sort through issues

At the time of this writing there are more than 35 open issues in RedMew and it can be hard to keep track of which ones have resolved themselves over time, which are duplicates, etc.

Following up on all these issues is difficult, and any help is appreciated. A good starting-off point is the [issues][1] list.

### Testing pre-release or in-progress features

Sometimes features have been fully written but get stuck waiting for someone to test them properly. An hour here or there testing an in-progress feature for bugs would help immensely. Ask in our [discord][2] if you're interested.

### Keeping the wiki and other documentation up to date

RedMew is a constantly evolving project and as such its documentation is constantly becoming outdated. All that is required is time.

Some ideas:

* look for typos

* find out-of-date sections (note them as such)

* write a new section on some aspect of RedMew that no one else has properly described

[1]:https://github.com/Refactorio/RedMew/issues
[2]:http://redmew.com/discord
