local on_game_created_from_scenario = function()
	storage.expansionRaised = false
	game.map_settings.enemy_expansion["min_expansion_cooldown"] = 36000		-- Reduces 10x when evolution reaches 1%
	game.map_settings.enemy_expansion["max_expansion_cooldown"] = 180000	-- Reduces 20x
	
	-- game.map_settings.path_finder.short_cache_size = 45
	-- game.map_settings.path_finder.long_cache_size = 256
	game.map_settings.path_finder.general_entity_collision_penalty = 3
	game.map_settings.path_finder.general_entity_subsequent_collision_penalty = 1
	
	game.map_settings.pollution.diffusion_ratio = 0.1		-- originally 0.1
	game.map_settings.pollution.ageing = 0.25
	game.map_settings.pollution.min_to_diffuse = 45
	
	storage.flamethrowerBaseDamage = math.sqrt(0.4)
	game.forces[1].set_turret_attack_modifier("flamethrower-turret", storage.flamethrowerBaseDamage - 1)
	game.forces[1].set_ammo_damage_modifier("flamethrower", storage.flamethrowerBaseDamage - 1)

	storage.rebuildBorder = 1000
	storage.blocksWithSmallBugs = 1920
	storage.attackConstant = 700		-- Controls how many bugs are sent.  Specifically it is the thereotical number of bugs that would be sent if a player entity was detected east of the eastern map edge by attackSeverityCutoff number of blocks.
	storage.attackSeverityCutoff = 8	-- Lower values cause a more drastic increase in the number of guard bugs as players move further east
	storage.mostEastPlayerObject = -3000
	storage.wakeDistance = 1500
	storage.combPitch = 0
	storage.atomicBombResearched = false
	storage.chestAndJimAlive = true
	storage.jimSawPlayer = false
	

	
	
	game.get_entity_by_tag("Chest").health = 93
	
	-- Daytime
	game.surfaces[1].dusk    = 0.375	-- When is the end of the day?        Default 0.25
	game.surfaces[1].evening = 0.475	-- When is the end of sunset?         Default 0.45
	-- Nighttime
	game.surfaces[1].morning = 0.625	-- When is the beginning of sunrise?  Default 0.55		
	game.surfaces[1].dawn    = 0.725	-- When is the end of sunrise?        Default 0.75
	-- Daytime again
	
	game.surfaces[1].daytime = 0.715		-- Set the time of day to mid-sunrise
	game.surfaces[1].ticks_per_day = 54000	-- Default 25000

	skyColor(game.surfaces[1].daytime)


	spider_init()


	-- Track enemy reactors
	local reactors = game.surfaces[1].find_entities_filtered{
		type = "reactor",
		force = "enemy",
		limit = 6,
		area = {
			left_top = {2955,-390},
			right_bottom = {2990, 390}
		}
	}
	
	storage.reactors = {}
	
	for id, reactor in pairs(reactors) do
		storage.reactors[reactor.unit_number] = reactor
	end

	-- Maintain a record of lost structures; attempt to rebuild them as ghosts.
	storage.rebuildList = {}
	
	-- Track sleeping blocks
	storage.blocks = {}
	for blockID = 0, 1919 do
		
		-- Scan rows in combs of 8.  For example, scan block 0, block 8, block 16, etc until end of row.  Then scan block 1, block 9, block 17, etc.
		local rowBlocks  =  math.floor(blockID / 120) * 120		-- Number of blocks in fully-completed rows
		local combBlocks = (math.floor(blockID /  15) * 15) % 120	-- Number of blocks in the current row that are in completed combs
		local currentComb =       8 * (blockID %  15)				-- Which multiple of 8 we'll select this time
		local block = currentComb + (combBlocks / 15) + rowBlocks		-- Select the next block
		
		
		-- Compute top left corner of the area
		local blockX = (          (block % 120) * 50) - 3000
		local blockY = (math.floor(block / 120) * 50) - 400
	
		-- Set the area
		storage.blocks[blockID] = {}
		storage.blocks[blockID].area = {
			left_top =     {x = blockX,      y = blockY     },
			right_bottom = {x = blockX + 50, y = blockY + 50}
		}
		storage.blocks[blockID].sleeping = false
		storage.blocks[blockID].hasPlayerStuff = false
		
		if blockX > -1700 and blockX < 2950 then
			storage.blocks[blockID].sleeping = true
			-- Find all enemies in the block
			local enemyEntities = game.surfaces[1].find_entities_filtered{
				area = storage.blocks[blockID].area,
				force = "enemy"		
			}
			
			-- Sleep precious
			for id, entity in pairs(enemyEntities) do
				if entity.name ~= "roboport" then	-- Except roboports.  You guys stay awake pls.
					entity.active = false
				end
			end
		end
		
	end
	
	
	-- Track pollution wall chunks
	storage.pollutionWalls = {}

	-- 0 - 29		West
	-- 30 - 59		East
	-- 60 - 251		North
	-- 252 - 443	South
	
	for id = 0, 29 do
		storage.pollutionWalls[id] = {"Y", id - 15, -96, 1}
	end

	for id = 30, 59 do
		storage.pollutionWalls[id] = {"Y", id - 30 - 15, 95, -1}
	end

	for id = 60, 251 do
		storage.pollutionWalls[id] = {"X", id - 60 - 96, -15, 1}
	end

	for id = 252, 443 do
		storage.pollutionWalls[id] = {"X", id - 252 - 96, 14, -1}
	end	
	
	
	-- Track player artillery wagons
	storage.playerWagons = {}
	
	
	-- For testing only
	-- for id, entity in pairs(game.surfaces[1].find_entities_filtered{force = "enemy", area = {left_top = {-3000,-400}, right_bottom = {2800, 400}}}) do entity.destroy() end
end




local on_tick = function(tick)
	
	-- Pollution for testing
	--game.surfaces[1].pollute({-2850,0},1)
	--game.surfaces[1].pollute({2850,0},1)
	--game.print(game.forces["enemy"].evolution_factor_by_pollution)
	
	antiExploit()
	
	defenceScan(tick.tick)
	rebuildDestroyedStructure(tick.tick)
	shootDownShells(tick.tick)
	disableAutotargeting()
	spider_on_tick()
	
	
	if tick.tick % 30 == 25 then
		chestGuard()
	end
	
	if tick.tick % 180 == 56 and game.finished_but_continuing == false then
		-- Create artillery-flares at nearby player wagons provided game is not won
		for id, wagon in pairs(storage.playerWagons) do
			if wagon and wagon.valid then
				-- Shoot a flare if it's close enough
				if wagon.position.x > 1769 then
					-- game.print("Shooting a flare at [gps=" .. wagon.position.x .. "," .. wagon.position.y .. "]")
					game.surfaces[1].create_entity{
						name = "artillery-flare",
						position = wagon.position,
						force = "enemy",
						movement = {0,0},
						height = 0,
						vertical_speed = 0,
						frame_speed = 1
					}
				end
			else
				-- Wagon no longer exists, remove it
				storage.playerWagons[id] = nil
				-- game.print("Removed wagon ID " .. id)
			end
		end
	end
	
	if tick.tick % 60 == 57 then
		skyColor(game.surfaces[1].daytime)
	end
	
	if tick.tick % 180 == 58 then
		local rocketSpeed  = -0.60 + (1.85  * game.forces["enemy"].get_evolution_factor()^2.5)
		local rocketDamage = -0.12 + (0.95 * game.forces["enemy"].get_evolution_factor()^2.5)
		game.forces["enemy"].set_gun_speed_modifier("rocket",rocketSpeed)
		game.forces["enemy"].set_ammo_damage_modifier("rocket",rocketDamage)
		raiseExpansion()
	end
	
	if tick.tick % 60 == 59 then				-- Make the first spoder very slow
		if game.get_entity_by_tag("enemySpider1") and game.get_entity_by_tag("enemySpider1").valid then
		
			local sticker = game.surfaces[1].create_entity{
				name = "acid-sticker-behemoth",
				position = game.get_entity_by_tag("enemySpider1").position,
				target = game.get_entity_by_tag("enemySpider1")
			}
			local sticker = game.surfaces[1].create_entity{
				name = "acid-sticker-big",
				position = game.get_entity_by_tag("enemySpider1").position,
				target = game.get_entity_by_tag("enemySpider1")
			}
		end
	end
	
	if tick.tick % 64 < 56 then
		unpolluteChunks(8 * (tick.tick % 64))
	end
	
	if tick.tick % 180 == 54 then
		removeFakeEntities()
	end
end


local on_player_joined_game = function(event)
	local character = game.get_player(event.player_index).character
	if character then
		character.disable_flashlight()		-- No flashlights allowed!
	end
end
local on_player_respawned = function(event)
	local character = game.get_player(event.player_index).character
	if character then
		character.disable_flashlight()		-- No flashlights allowed!
	end
end
local on_research_finished = function(event)
	if event.tick == 0 then return end	-- So editor doesnt crash
	local researchName = event.research.name
	researchName = researchName:sub(1,18)	
	if researchName == "refined-flammables" then
		local newModifier = (storage.flamethrowerBaseDamage - 1) + (storage.flamethrowerBaseDamage * event.research.level * 0.2)
		game.forces[1].set_turret_attack_modifier("flamethrower-turret", storage.flamethrowerBaseDamage - 1)
		game.forces[1].set_ammo_damage_modifier("flamethrower", newModifier)
	end
	if researchName == "atomic-bomb" or "artillery" then
		storage.atomicBombOrArtyResearched = true
	end
end


script.on_event(defines.events.on_pre_player_mined_item,
	function(event)
		event.entity.order_deconstruction(game.forces[1])
	end
)
script.set_event_filter(defines.events.on_pre_player_mined_item,{{filter = "type", type = "land-mine"}})  -- Filter to get only landmines


script.on_event(defines.events.on_marked_for_deconstruction,
	function(event)
		event.entity.die()
	end
)
script.set_event_filter(defines.events.on_marked_for_deconstruction,{{filter = "type", type = "land-mine"}})  -- Filter to get only landmines


script.on_event(defines.events.on_post_entity_died,		-- When a simple-entity-with-force dies, destroy its corpse.  When a spawner dies, check if the game is won.  When a reactor dies, remove it from the list of reactors.
	function(event)
		-- game.print(event.prototype.type)
		
		if event.prototype.type == "simple-entity-with-force" then
			if event.corpses[1] then	-- Nuclear blasts can destroy corpses, so this could be nil
				event.corpses[1].destroy()
				return
			end
		end
		if event.prototype.type == "reactor" then
			storage.reactors[event.unit_number] = nil
			-- game.print("Removed a reactor")
			-- game.print(serpent.line(storage.reactors))
		end
		
		local unitSpawners = game.forces["enemy"].get_entity_count("biter-spawner") + game.forces["enemy"].get_entity_count("spitter-spawner")
		local reactors = game.forces["enemy"].get_entity_count("nuclear-reactor")
		local spiders = game.forces["enemy"].get_entity_count("spidertron")
		if unitSpawners == 0 and spiders == 0 and reactors == 0 then
			-- No spawners left!  Game is won
			game.set_game_state{
				game_finished = true,
				player_won = true,
				can_continue = true,
				victorious_force = "player"
			}
		end
	end
)
script.set_event_filter( defines.events.on_post_entity_died,
	{
		{filter = "type", type = "unit-spawner"},
		{mode = "or", filter = "type", type = "reactor"},
		{mode = "or", filter = "type", type = "simple-entity-with-force"},
		{mode = "or", filter = "type", type = "spider-vehicle"}
	}
)


script.on_event(defines.events.on_robot_built_entity,	-- When a reactor is rebuilt, add it to the list of reactors.
	function(event)
		if event.entity.name == "artillery-wagon" then
			storage.playerWagons[event.entity.unit_number] = event.entity
			--game.print("Added an artillery-wagon")
		end
		
		if event.entity.type == "reactor" and event.entity.force.name == "enemy" then
			storage.reactors[event.entity.unit_number] = event.entity
			--game.print("Added a reactor")
			-- game.print(serpent.line(storage.reactors))
		end
		
	end
)	-- Filter to get only enemy reactors/requester chests and player wagons
script.set_event_filter( defines.events.on_robot_built_entity, { {filter = "type", type = "reactor"}, {mode = "or", filter = "name", name = "artillery-wagon"}, {mode = "or", filter = "name", name = "requester-chest"} } )


script.on_event(defines.events.on_entity_died,			-- When a rebuildable structure is destroyed, add it to a list of structures we'll try to rebuild later
	function(event)
		if event.entity.force.name ~= "enemy" then return end
		local entityName = event.entity.name
		local entityPos = event.entity.position
		
		if event.entity.type == "spider-vehicle" then
			local entityGPS = "[gps=" .. math.floor(entityPos.x + 0.5) .. "," .. math.floor(entityPos.y) .. "]"
			if event.cause then
				
				if event.cause.name == "character" then
					-- Killed by a player on foot
					game.print({"multiplayer.player-died-by", event.entity.localised_name, event.cause.player.name, entityGPS})
					return
				end
				if event.cause.name == "spidertron" or event.cause.name == "tank" or event.cause.name == "car" then
					local driver = event.cause.get_driver()
					if driver then
						if driver.name == "character" then
							-- Killed by a player in a vehicle
							game.print({"multiplayer.player-died-by", event.entity.localised_name, driver.player.name, entityGPS})
						else
							-- Killed by a remotely-driven vehicle
							game.print({"multiplayer.player-died-by", event.entity.localised_name, driver.name, entityGPS})
						end
						return
					end
				end
				
				-- Killed by a follower spider, unmanned laser tank, or something else
				game.print({"multiplayer.player-died-by", event.entity.localised_name, event.cause.localised_name, entityGPS})
			else
				-- Died of natural causes
				game.print({"multiplayer.player-died", event.entity.localised_name, entityGPS})
			end
			return
		end
		
		if entityPos.x > storage.rebuildBorder and entityName ~= "land-mine" then
			storage.rebuildList[#storage.rebuildList + 1] = {
				name = entityName,
				direction = event.entity.direction,
				position = {entityPos.x, entityPos.y},
				rectangle = event.entity.selection_box
			}
		end
		
		local logiPoint = event.entity.get_logistic_point()
		
		if logiPoint and logiPoint[1] then
			local section = logiPoint[1].get_section(1)
			if section then
				local slot = section.get_slot(1)
				storage.rebuildList[#storage.rebuildList].slot = slot
			end
		end
		
	end
)
script.set_event_filter(defines.events.on_entity_died,	-- Filter to get only ghost-rebuildable buildings / blocking buildings
	{
		{filter = "type", type = "unit", invert = true},
		{filter = "type", type = "unit-spawner", invert = true, mode = "and"},
		{filter = "type", type = "turret", invert = true, mode = "and"},
		{filter = "type", type = "tree", invert = true, mode = "and"},
		{filter = "type", type = "construction-robot", invert = true, mode = "and"},
		{filter = "type", type = "logistic-robot", invert = true, mode = "and"},
		{filter = "type", type = "spider-leg", invert = true, mode = "and"},
		{filter = "type", type = "simple-entity", invert = true, mode = "and"}
	}
)


script.on_event(defines.events.on_built_entity,			-- When a player spider or wagon is built, add it to the list of player spiders
	function(event)
		if event.entity.name == "artillery-wagon" then
			storage.playerWagons[event.entity.unit_number] = event.entity
			-- game.print("Added a player wagon to the list of player wagons")
			return
		end
		
		if not storage.playerSpiders then storage.playerSpiders = {} end
		storage.playerSpiders[event.entity.unit_number] = event.entity
		-- game.print("Added a player spider to the list of player spiders")
	end
)
script.set_event_filter( defines.events.on_built_entity, {  {filter = "type", type = "spider-vehicle"}, {mode = "or", filter="name", name = "artillery-wagon"}, {mode = "and", filter = "force", force = "player"}  } )


function antiExploit()
	for i, player in pairs(game.connected_players) do
		if player.driving and player.vehicle.force.name ~= "player" then
			player.driving = false
		end
	end
end


function chestGuard()
	if storage.chestAndJimAlive == false then return end
	local chest = game.get_entity_by_tag("Chest")
	local jim   = game.get_entity_by_tag("Jim")
	if jim and chest then
		local playerNearby = game.surfaces[1].count_entities_filtered{
			area = {
				left_top     = {-3000,340},
				right_bottom = {-2935,400}
			},
			collision_mask = {
				player = true,
				object = true,
				train = true,
				rail = true,
				transport_belt = true,
			},
			force = "player",
			limit = 1
		}
		local edgeCase = game.surfaces[1].count_entities_filtered{
			area = {
				left_top     = {-3000,340},
				right_bottom = {-2935,400}
			},
			type = {"projectile", "construction-robot"},
			limit = 1
		}
		if playerNearby > 0 or edgeCase > 0 or storage.jimSawPlayer then
			chest.force = "player"
			storage.jimSawPlayer = true
			jim.shooting_target = chest
		end
	else
		storage.chestAndJimAlive = false
	end
end



function disableAutotargeting()
	-- Disable auto-targeting mode for any player spiders that are armed with atomic bomb
	for i, playerSpider in pairs(storage.playerSpiders) do
		local atomicBombs = playerSpider.get_inventory(defines.inventory.spider_ammo).get_item_count("atomic-bomb")
		if atomicBombs > 0 then
			local params = playerSpider.vehicle_automatic_targeting_parameters
			params.auto_target_with_gunner    = false
			params.auto_target_without_gunner = false
			playerSpider.vehicle_automatic_targeting_parameters = params
			
			-- game.print("The contents of params is:")
			-- game.print(serpent.line(params))
			-- game.print("The contents of vehicle_automatic_targeting_parameters is:")
			-- game.print(serpent.line(playerSpider.vehicle_automatic_targeting_parameters))
			-- game.print("--")
		end
	end
end


function shootDownShells(tick)
	
	if storage.laser and storage.laser.valid then
		storage.laser.destroy()
	end
	
	local numShells = game.forces["player"].get_entity_count("artillery-projectile")
	if numShells == 0 then return end		-- No shells in flight
	-- game.print(numShells .. " player shells are in flight")
	
	local hotReactors = {}
	
	local id = 1 + (tick % #hotReactors)
	
	for id, reactor in pairs(storage.reactors) do
		if reactor and reactor.valid  and reactor.temperature > 500 then
			hotReactors[#hotReactors+1] = reactor
		end
	end
	
	if #hotReactors == 0 then return end
	-- game.print("Found " .. #hotReactors .. " hot reactors.")
	
	local id = 1 + (tick % #hotReactors)

	local shells = game.surfaces[1].find_entities_filtered{
		force = "player",
		name = "artillery-projectile",
		position = hotReactors[id].position,
		radius = 65,
		limit = 1
	}
	
	if #shells > 0 then
		-- game.print("A shell is closing on a reactor")
		game.forces["player"].chart(game.surfaces[1],
		{
			lefttop     = {x = hotReactors[id].position.x - 20, y = hotReactors[id].position.y - 20},
			rightbottom = {x = hotReactors[id].position.x + 20, y = hotReactors[id].position.y + 20}
		})
		
		local closeShells = game.surfaces[1].find_entities_filtered{
			force = "player",
			name = "artillery-projectile",
			position = hotReactors[id].position,
			radius = 45,
			limit = 1
		}
		
		if #closeShells > 0 then				
			-- game.print("Detected an incoming shell near a hot reactor")
			game.surfaces[1].create_entity({name = "big-artillery-explosion", position = closeShells[1].position})
			storage.laser = game.surfaces[1].create_entity({name = "laser-beam", position=hotReactors[id].position, source = hotReactors[id].position, target_position = closeShells[1].position})
			closeShells[1].destroy()
		end
	end

end


function rebuildDestroyedStructure(tick)
	if #storage.rebuildList == 0 then return end
	
	-- Calculate what index we should be on this tick - this makes it cycle between all the elements in the rebuildList
	local i = (tick % #storage.rebuildList) + 1
	
	-- Check row i of the rebuild list to see what this thing is
	local structure = storage.rebuildList[i].name
	local pos = storage.rebuildList[i].position
	
	-- Look for any nearby player structures
	local playerStructures = game.surfaces[1].find_entities_filtered{
		area = storage.rebuildList[i].rectangle,
		force = "player",
		collision_mask = {object = true}
	}
	
	-- The ghost was already removed if a player structure is nearby.
	if #playerStructures > 0 then
		return
	end
	
	-- Look for any existing ghost
	local ghost = game.surfaces[1].find_entity("entity-ghost",pos)
	
	-- Has the ghost already been added?
	if ghost and ghost.ghost_name and ghost.force.name == "enemy" then
		return
	end
	
	-- Has this structure been rebuilt?
	local rebuilt = game.surfaces[1].find_entity(structure,pos)
	if rebuilt and rebuilt.force.name == "enemy" then
		if storage.rebuildList[i].slot then
			local logiPoint = rebuilt.get_logistic_point()
			local section = logiPoint[1].get_section(1)
			section.set_slot(1, storage.rebuildList[i].slot)
		end
		storage.rebuildList[i] = storage.rebuildList[#storage.rebuildList]		-- Overwrite this index with the last index in the rebuild list
		storage.rebuildList[#storage.rebuildList] = nil						-- Then delete the last index in the rebuild list
		return
	end
	
	-- Rebuild this structure's ghost
	local rebuiltEntity = game.surfaces[1].create_entity{
		name = "entity-ghost",
		direction = storage.rebuildList[i].direction,
		position = pos,
		inner_name = storage.rebuildList[i].name
	}
	
	if storage.rebuildList[i].section then
		local logiPoint = rebuiltEntity.get_logistic_point()
	end
end


function removeSmallBugs(blockArea)
	local smallBugs = game.surfaces[1].find_entities_filtered{
		area = blockArea,
		name = {"small-biter", "small-spitter"}
	}
	for id, bug in pairs(smallBugs) do
		if bug.valid then bug.destroy() end	-- muahahaha
	end
	storage.blocksWithSmallBugs = storage.blocksWithSmallBugs - 1
	-- game.print("Removed " .. #smallBugs .. " small bugs from " .. serpent.line(blockArea))
end


function raiseExpansion()
	if storage.expansionRaised then return end	-- We already raised expansion
	
	if game.forces["enemy"].get_evolution_factor() > 0.01 then	
		game.map_settings.enemy_expansion["min_expansion_cooldown"] = 3600
		game.map_settings.enemy_expansion["max_expansion_cooldown"] = 9000
		game.map_settings.enemy_expansion["friendly_base_influence_radius"] = 1
		game.map_settings.enemy_expansion["enemy_building_influence_radius"] = 1
		game.map_settings.enemy_evolution["pollution_factor"] = 0.0000008
		storage.expansionRaised = true
	end
end


function defenceScan(tick)
	-- Update the block counter
	local blockIndex = tick % 1920
	
	if blockIndex == 0 then storage.combPitch = storage.combPitch + 1 end
	if storage.combPitch == 50 then storage.combPitch = 0 end
	
	-- Set the area for the attack scan (wakeup uses its own areas)
	local block = storage.blocks[blockIndex]
	local combPitch = storage.combPitch
	local attackArea = {
		left_top =     { x = block.area.left_top.x     + combPitch, y = block.area.left_top.y     },
		right_bottom = { x = block.area.right_bottom.x + combPitch, y = block.area.right_bottom.y }
	}
	
	local evolution = game.forces["enemy"].get_evolution_factor()
	
	-- Remove small bugs if required
	if storage.blocksWithSmallBugs ~= 0 and evolution > 0.7 then
		removeSmallBugs(block.area)
	end
	
	local surface = game.surfaces[1]
	
	-- Search for player stuff
	local playerEntitiesInArea = surface.find_entities_filtered{
		area = attackArea,
		force = "player",
		collision_mask = {
			object = true,
			rail = true,
			player = true,
			train = true,
			transport_belt = true
		},
		limit = 9
	}
	
	-- Also search for any player spiders, adding a found spider to the start of the list
	for id, spider in pairs(storage.playerSpiders) do
		if  spider.valid then
			if spider.position.x > attackArea.left_top.x 
			and spider.position.y > attackArea.left_top.y
			and spider.position.x <= attackArea.right_bottom.x
			and spider.position.y <= attackArea.right_bottom.y then
				table.insert(playerEntitiesInArea, 1, spider)
			end
		else
			-- Spider is no longer valid, probably destroyed.  Remove from the list
			storage.playerSpiders[id] = nil
		end
	end
	
	if #playerEntitiesInArea == 0 then			-- Nothing here
		storage.blocks[blockIndex].hasPlayerStuff = false
		if block.sleeping and storage.mostEastPlayerObject + storage.wakeDistance > block.area.left_top.x then
			--game.print("Waking block " .. blockIndex .. "   [gps=" .. block.area.left_top.x .. "," .. block.area.left_top.y .. "]")
			storage.blocks[blockIndex].sleeping = false
			local enemyEntities = surface.find_entities_filtered{area = block.area, force = "enemy"}
			for id, entity in pairs(enemyEntities) do
				entity.active = true		-- Awaken my minions !
			end			
		end
		return
	end	
	
	--[[if storage.blocks[blockIndex].hasPlayerStuff == false then
		game.print("Saw player stuff at Block Index: " .. blockIndex .. " which contains: " .. serpent.line(storage.blocks[blockIndex]))
		rendering.draw_rectangle{surface = game.surfaces[1], left_top = block.area.left_top, right_bottom = block.area.right_bottom, color = {1, 1, 1}}
		game.print("A player object placed in the center of this block would have coordinates" .. block.area.left_top.x + 25 .. ", " .. block.area.left_top.y + 25)
		game.print("We detect that position as block " .. getBlockID({block.area.left_top.x + 25, block.area.left_top.y + 25}))
	end--]]
	storage.blocks[blockIndex].hasPlayerStuff = true
	
	
	
	
	if attackArea.left_top.x > storage.mostEastPlayerObject then	-- Is this the furthest east object we've seen so far?
		-- game.print("Updating mostEastPlayerObject - player object detected at block " .. block .. "   [gps=" .. blockX .. "," .. blockY .. "])
		storage.mostEastPlayerObject = attackArea.left_top.x
	end
	
	local floor = math.floor
	
	-- How far west is this block?
	local westness  = (119 + storage.attackSeverityCutoff) - floor((attackArea.left_top.x + 3000) / 50)		-- Low values of westness indicate this block is near the east.
	
	-- Compute the number of bugs to send on attack
	local attackers = floor(evolution^0.5 * (storage.attackConstant / westness))
	
	-- Return if we aren't sending any bugs
	if attackers == 0 then return end
	
	-- Return if there is only a tiny amount of spawners left
	local unitSpawners = game.forces["enemy"].get_entity_count("biter-spawner") + game.forces["enemy"].get_entity_count("spitter-spawner")
	if unitSpawners < 30 then return end
	
	-- game.print("We found " .. #playerEntitiesInArea .. " things")
	
	local commandList = {}
	-- Go to location of the first thing
	commandList[1] = {
		type = defines.command.go_to_location,
		destination = playerEntitiesInArea[1].position,
		distraction = defines.distraction.by_anything
	}
	
	-- Then attack each thing
	for i = 1, #playerEntitiesInArea do
		commandList[i+1] = {   type = defines.command.attack, target = playerEntitiesInArea[i], distraction=defines.distraction.by_anything   }
	end
	
	-- After that, go to location of last destroyed structure
	commandList[#commandList+1] = {
		type = defines.command.go_to_location,
		destination = playerEntitiesInArea[#playerEntitiesInArea].position
	}
	
	local compound = {
		type = defines.command.compound,
		structure_type = defines.compound_command.return_last,
		commands = commandList
	}
	
	local unitsSent = surface.set_multi_command{
		command = compound,
		unit_count = attackers,
		unit_search_distance = 400
	}
	
	--[[
	game.print(
		"Block: "       .. block     ..
		"  Westness: "  .. westness  ..
		"  Attackers: " .. attackers ..
		"  unitsSent: " .. unitsSent ..
		"  Area: "      .. serpent.line(blockArea)
	)
	]]
end


function skyColor(daytime)
	-- We are given a value between 0 and 1 representing the time of day, and need to color the sky corresponding
	local surface = game.surfaces[1]
	
	if daytime < surface.dusk then return end	-- Day
	if daytime > surface.dawn then return end	-- Day
	
	if daytime > surface.evening and daytime < surface.morning then return end	-- Night
	
	-- Daytime is between 0.375 and 0.475, or 0.625 and 0.725
	
	local redIntensity = 0.6
	local greenIntensity = -0.15
	
	local red = 1 / 0.98
	local green = 1 / 0.96
	local blue = 1 / 1.05
	
	-- When the product of redFactor and redIntensity is 0, it's full darkness
	if daytime < 0.5 then
		-- Sunset
		local redFactor = 1 - ((daytime - surface.dusk) * 10)		-- redFactor is a value between 1 and 0, where 1 is the beginning of sunset and 0 is the end of sunset
		red = 1 / (0.98 + (redFactor * redIntensity))
		
		if daytime > 0.425 then
			-- Start removing green
			local greenFactor = 1 - ((daytime - 0.425) * 20)	-- greenFactor is a value between 1 and 0, where 1 is halfway through sunset, and 0 is the end of sunset
			green = 1 / (0.96 + (greenFactor * greenIntensity))
		else
			-- Not time to remove green yet
			green = 1 / (0.96 + greenIntensity)
		end
		-- game.print("Sunset.   Red: " .. red .. "   Green: " .. green)
	else
		-- Sunrise
		local redFactor = (daytime - surface.morning) * 10		-- redFactor is a value between 0 and 1, where 0 is the beginning of sunrise and 1 is the end of sunrise
		red = 1 / (0.98 + (redFactor * redIntensity))
		
		if daytime > 0.675 then
			-- Start adding green
			local greenFactor = (daytime - 0.675) * 20	-- greenFactor is a value between 0 and 1, where 0 is halfway through sunrise, and 1 is the end of sunrise
			green = 1 / (0.96 + (greenFactor * greenIntensity))
		else
			-- Not time to start adding green yet
			green = 1 / 0.96
		end
			
		-- game.print("Sunrise.   Red: " .. red .. "   Green: " .. green)
	end
	
	surface.brightness_visual_weights = {
		r = red,
		g = green,
		b = blue,
		a = 1
	}
	
end


function unpolluteChunks(unsignedChunk)
	-- We are given a chunk numbered from 0 - 439 and must move the pollution from it, along with the subsequent 7 chunks
	local pollutionWall = nil
	local pollutionWalls = storage.pollutionWalls
	
	for offset = 0, 7 do
		pollutionWall = pollutionWalls[unsignedChunk + offset]
		if not pollutionWall then return end	-- No data for this wall
		if pollutionWall[1] == "X" then
			movePollutionX(			-- Function call
				pollutionWall[2],	-- chunk
				pollutionWall[3],	-- border
				pollutionWall[4]	-- sign
			)
		else
			movePollutionY(			-- Function call
				pollutionWall[2],	-- chunk
				pollutionWall[3],	-- border
				pollutionWall[4]	-- sign
			)
		end
	end
end


function movePollutionX(chunk, border, sign)
	local surface = game.surfaces[1]
	local origin = {chunk * 32, border * 32}
	local amount = surface.get_pollution(origin)
	if amount == 0 then return end
	local destination = {
		32 * math.min( chunk+1,	10 + math.floor(storage.mostEastPlayerObject / 32) ),
		32 * (border + sign)
	}
	local evo = game.forces["enemy"].get_evolution_factor()
	--game.print(game.tick .. "  Move Pollution X - Chunk: " .. chunk .. "   border: " .. border .. "   sign: " .. sign .. "   amount: " .. amount)
	
	surface.pollute(origin, amount * -1)
	
	local evoReduction = (1 - evo)^2 * game.map_settings.enemy_evolution["pollution_factor"] * amount
	game.forces["enemy"].set_evolution_factor(evo - evoReduction)
	
	local evoByPollution     = game.forces["enemy"].get_evolution_factor_by_pollution()
	local evoPollutionFactor = game.map_settings.enemy_evolution["pollution_factor"]
	game.forces["enemy"].set_evolution_factor_by_pollution(evoByPollution - (evoPollutionFactor * amount))
	
	surface.pollute(destination, amount)
end


function movePollutionY(chunk, border, sign)
	local surface = game.surfaces[1]
	local origin = {border * 32, chunk * 32}
	local amount = surface.get_pollution(origin)
	if amount == 0 then return end
	local destination = {(border + sign) * 32, chunk * 32}
	local evo = game.forces["enemy"].get_evolution_factor()
	--game.print(game.tick .. "  Move Pollution Y - Chunk: " .. chunk .. "   border: " .. border .. "   sign: " .. sign .. "   amount: " .. amount)
	
	surface.pollute(origin, amount * -1)
	
	local evoReduction = (1 - evo)^2 * game.map_settings.enemy_evolution["pollution_factor"] * amount
	game.forces["enemy"].set_evolution_factor(evo - evoReduction)
	
	local evoByPollution     = game.forces["enemy"].get_evolution_factor_by_pollution()
	local evoPollutionFactor = game.map_settings.enemy_evolution["pollution_factor"]
	game.forces["enemy"].set_evolution_factor_by_pollution(evoByPollution - (evoPollutionFactor * amount))
	
	surface.pollute(destination, amount)
end



local world = {}
world.events = {
	[defines.events.on_game_created_from_scenario]    = on_game_created_from_scenario,
	[defines.events.on_player_joined_game]            = on_player_joined_game,
	[defines.events.on_player_respawned]              = on_player_respawned,
	[defines.events.on_tick]                          = on_tick,
	[defines.events.on_research_finished]             = on_research_finished
}
return world