function sup(spiderTag, commander)
	-- Report on the status of the named spider
	local spider = {}
	if spiderTag and type(spiderTag) == "string" then
		if game.get_entity_by_tag(spiderTag) then
			spider = storage.enemySpiders[game.get_entity_by_tag(spiderTag).unit_number]
		else
			commander.print(spiderTag .. " is dead or does not exist.")
			return
		end
	else
		commander.print("You just entered some garbage.")
		return
	end
	
	local ammoInLaunchers = spider.spiderObject.get_inventory(defines.inventory.spider_ammo).get_item_count(spider.ammoType)
	local ammoInTrunk     = spider.spiderObject.get_inventory(defines.inventory.spider_trunk).get_item_count(spider.ammoType)
	local spiderAmmo      = ammoInLaunchers + ammoInTrunk
	local batteryLevel = 1
	
	local requestSlot = spider.spiderObject.get_requester_point().get_section(1).get_slot(1)
	
	
	if spider.spiderObject.grid.battery_capacity > 0 then
		batteryLevel  = spider.spiderObject.grid.available_in_batteries / spider.spiderObject.grid.battery_capacity
	end

	local attackETA
	if spider.spiderObject.active then
		attackETA = ((spider.patrolsToTriggerAttack - 1) - spider.patrolsDone) * (#spider.route.patrol * storage.interpolationDistance)
		attackETA = attackETA + (storage.interpolationDistance * (#spider.route.patrol - spider.patrolWaypointID))
		attackETA = attackETA / 767
		if spiderTag == "enemySpider1" then
			attackETA = attackETA * 3.8
		end
		attackETA = math.abs(math.max(math.ceil(attackETA), 0))
	else
		attackETA = "inf"
	end
	
	
	commander.print(
		spiderTag      ..
		"   Active: "  .. tostring(spider.spiderObject.active)       ..
		"   [gps="     .. math.floor(spider.spiderObject.position.x) .. "," .. math.floor(spider.spiderObject.position.y) .. "]" ..
		"   Com: "     .. spider.commuteWaypointID                   .. "/" .. #spider.route.commute       ..
		"   Patrol: "  .. spider.patrolWaypointID                    .. "/" .. #spider.route.patrol        ..
		"   Patrols: " .. spider.patrolsDone                         .. "/" .. spider.patrolsToTriggerAttack  ..
		"   Attack ETA: " .. attackETA .. " mins"
	)
	commander.print(
		"   Ammo: "    .. spider.ammoType .. ": " .. spider.lowAmmo      .. "/" .. spiderAmmo .. "/" .. spider.fullAmmo   ..
		"   Request: " .. requestSlot.value.name   .. " x " .. requestSlot.min ..
		"   Battery: " .. batteryLevel .. "   Health: " .. spider.spiderObject.health ..
		"   CanSeeMines: " .. serpent.line(spider.canSeeMines)
	)
	
	local ttl = 3000
	for waypoint, data in pairs(spider.route.attack) do
		rendering.draw_circle{
			surface = game.surfaces[1],
			color = {0.6, 0, 0, 0.6},
			radius = 3.5,
			filled = true,
			time_to_live = ttl,
			players = {commander},
			target = spider.route.attack[waypoint].position
		}
		rendering.draw_text{
			surface = game.surfaces[1],
			color = {1, 0.5, 0, 0.4},
			scale = 8 - (5 * waypoint / #spider.route.attack),
			text = waypoint,
			time_to_live = ttl,
			players = {commander},
			target = spider.route.attack[waypoint].position
		}
	end
	for waypoint, data in pairs(spider.route.patrol) do
		rendering.draw_circle{
			surface = game.surfaces[1],
			color = {0.0, 0.3, 0.0, 0.3},
			radius = 2.5,
			filled = true,
			time_to_live = ttl,
			players = {commander},
			target = spider.route.patrol[waypoint].position
		}
		rendering.draw_text{
			surface = game.surfaces[1],
			color = {0, 0.5, 1, 0.4},
			scale = 8 - (5 * waypoint / #spider.route.patrol),
			text = waypoint,
			time_to_live = ttl,
			players = {commander},
			target = spider.route.patrol[waypoint].position
		}
	end
	
	return spider
end


commands.add_command("sup", nil, function(command)
	local commander = game.get_player(command.player_index)
	if command.parameter == nil then commander.print("No spider name provided") return end
	
	if not commander.admin then
		commander.print("cannot run command (" .. command.name .. ") - you are not an admin")
		return
	end
	
	sup(command.parameter, commander)
end)


function history(positionString, commander)
	-- Scan through the undo stack of all players to look for actions corresponding to this position, then display them
	local x, y = string.match(positionString, "gps=([%-%d%.]+),([%-%d%.]+)")	
	local pos = { x = tonumber(x), y = tonumber(y) }
	
	if pos.x == nil or pos.y == nil then commander.print("Invalid position") return end
	
	-- Perform the scan
	for i, suspect in pairs(game.players) do
		local undo_item_count = suspect.undo_redo_stack.get_undo_item_count()
		for j = 1, undo_item_count do
			local undoItem = suspect.undo_redo_stack.get_undo_item(j)
			for k, action in pairs(undoItem) do
				if actionIsAtPosition(action, pos) then displayHistoryEntry(suspect, action, commander) end
			end
		end
	end
end

commands.add_command("history", nil, function(command)
	local commander = game.get_player(command.player_index)
	if command.parameter == nil then commander.print("No location provided") return end
	
	if not commander.admin then
		commander.print("cannot run command (" .. command.name .. ") - you are not an admin")
		return
	end
	
	history(command.parameter, commander)
end)

function actionIsAtPosition(a, p)
	-- return true if this action is located at the given position
	if a.target and a.target.position then
		--[[local atp = a.target.position
		if atp.x == p.x and atp.y == p.y then
			return true
		end
		]]
		
		if positionIsInEntity(p, a.target.name, a.target.position) then
			return true
		end
	end
	return false
end

function positionIsInEntity(pos, ent, entPos)
	-- Expects a position, an entity name, and the position of that entity.  Return true if the position is inside the entity
	local area = prototypes.entity[ent].selection_box
	local bounding_box = {
		left_top = {
			x = entPos.x + area.left_top.x,
			y = entPos.y + area.left_top.y
		},
		right_bottom = {
			x = entPos.x + area.right_bottom.x,
			y = entPos.y + area.right_bottom.y
		}
	}
	--game.print("Position: " .. serpent.line(pos))
	--game.print("Entity Name: " .. ent)
	--game.print("Entity Position: " .. serpent.line(entPos))
	--game.print("Entity Area: " .. serpent.line(area))
	--game.print("Bounding Box: " .. serpent.line(bounding_box))
	--game.print("Result of positionInArea: " .. serpent.line(positionInArea(pos, bounding_box)))
	
	if positionInArea(pos, bounding_box) then
		return true
		--game.print("Position is in the area")
	else
		return false
		--game.print("Position is not in the area")
	end

end

-- /sc game.print(serpent.line(prototypes.entity["stone-furnace"].selection_box))

function displayHistoryEntry(suspect, action, commander)
	commander.print(
		suspect.name .. " " ..
		action.type .. " " ..
		action.target.name .. " at [gps=" ..
		action.target.position.x .. "," ..
		action.target.position.y .. "]")
end


function debugAttackArea(tag)
	if tag then
		showAttackAreaInfo(tag)
		return
	end
	for i = 1, 10 do
		showAttackAreaInfo("enemySpider" .. i)
	end
end


function showAttackAreaInfo(tag)
	local attackColor = {0, 1, 1}
	local patrolColor = {1, 0, 1}
	local ttl = 3000
	
	local spider = {}
	spider.attackArea = storage.enemySpiders[game.get_entity_by_tag(tag).unit_number].attackArea
	spider.patrolArea = storage.enemySpiders[game.get_entity_by_tag(tag).unit_number].patrolArea

	rendering.draw_text{
		text = tag .. " - Attack Area - Left Top",
		color = attackColor,
		time_to_live = ttl,
		scale = 6,
		surface = game.surfaces[1],
		target = spider.attackArea.left_top
	}
	rendering.draw_text{
		text = tag .. " - Attack Area - Right Bottom",
		color = attackColor,
		time_to_live = ttl,
		scale = 6,
		surface = game.surfaces[1],
		target = spider.attackArea.right_bottom
	}
	rendering.draw_rectangle{
		color = attackColor,
		width = 6,
		time_to_live = ttl,
		surface = game.surfaces[1],
		left_top = spider.attackArea.left_top,
		right_bottom = spider.attackArea.right_bottom
	}
	
	
	rendering.draw_text{
		text = tag .. " - Patrol Area - Left Top",
		color = patrolColor,
		time_to_live = ttl,
		scale = 6,
		surface = game.surfaces[1],
		target = spider.patrolArea.left_top
	}
	rendering.draw_text{
		text = tag .. " - Patrol Area - Right Bottom",
		color = patrolColor,
		time_to_live = ttl,
		scale = 6,
		surface = game.surfaces[1],
		target = spider.patrolArea.right_bottom
	}
	rendering.draw_rectangle{
		color = patrolColor,
		width = 3,
		time_to_live = ttl,
		surface = game.surfaces[1],
		left_top = spider.patrolArea.left_top,
		right_bottom = spider.patrolArea.right_bottom
	}
end


function drawRoute(route)
	local ttl = 1800
	local existingTag
	for t, tag in pairs(game.player.force.find_chart_tags(game.surfaces[1])) do
		tag.destroy()
	end
	for step, poi in pairs(route) do
		if step == 1 then
			game.player.force.add_chart_tag(game.surfaces[1], {position = storage.poi[poi].position, text = "POI " .. poi .. "   #" .. step .. ", #" .. #route})
		end
		if step > 1 then
			rendering.draw_line{
				surface = game.surfaces[1],
				time_to_live = ttl,
				from = storage.poi[route[step - 1]].position,
				to = storage.poi[route[step]].position,
				color = {
					1 - ((1 / #route) * step),
					((1 / #route) * step),
					0,
					0.5
				},
				width = 30
			}
			rendering.draw_text{
				surface = game.surfaces[1],
				text = step,
				target = storage.poi[route[step]].position,
				time_to_live = ttl,
				color = {
					1 - ((1 / #route) * step),
					((1 / #route) * step),
					0,
					0.5
				},
				scale = 30
			}
			if step < #route then
				existingTag = game.player.force.find_chart_tags(
					game.surfaces[1],
					{
						left_top = {
							x = storage.poi[route[step]].position.x - 0.5,
							y = storage.poi[route[step]].position.y - 0.5
						},
						right_bottom = {
							x = storage.poi[route[step]].position.x + 0.5,
							y = storage.poi[route[step]].position.y + 0.5
						}
					}
				)
				
				if #existingTag > 0 then
					existingTag[1].text = existingTag[1].text .. ", #" .. step
				else
					game.player.force.add_chart_tag(game.surfaces[1], {position = storage.poi[poi].position, text = "POI " .. poi .. "   #" .. step})
				end
			end
		end
	end
end


function poiInfo(id)
	local poiPosition = serpent.line(storage.poi[id].position)
	
	game.player.print("POI " .. id .. ": " .. poiPosition)
	
	for otherPoi, waypoints in pairs(storage.poi[id].reachablePoi) do
		-- Cycling through IDs of other Pois that are traversable from this Poi
		local lastWP  = storage.poi[id].reachablePoi[otherPoi][#waypoints]
		game.player.print(otherPoi .. " --> " .. serpent.line(lastWP))		
	end
end


function debugPoi(id)
	
	local ttl = 5000
	
	if not id then
		for t, tag in pairs(game.player.force.find_chart_tags(game.surfaces[1])) do
			tag.destroy()
		end
		for i, poi in pairs(storage.poi) do
			rendering.draw_circle{surface = game.surfaces[1], color = {1, 0.2, 0.2}, radius = 5, filled = true, time_to_live = ttl, target = poi.position}
			rendering.draw_text{text = "POI " .. i, color = {0.5, 0.5, 0.5}, time_to_live = ttl, scale = 30, surface = game.surfaces[1], target = poi.position}
			
			game.player.force.add_chart_tag(game.surfaces[1], {position = poi.position, text = "POI " .. i})
		end
		game.player.print("Showing " .. #storage.poi .. " points of interest")
		return
	end
	
	local poi = storage.poi[id]
	rendering.draw_circle{surface = game.surfaces[1], color = {1, 0.2, 0.2}, radius = 5, filled = true, time_to_live = ttl, target = storage.poi[id].position}
	rendering.draw_text{text = "POI " .. id, color = {0.5, 0.5, 0.5}, time_to_live = ttl, scale = 30, surface = game.surfaces[1], target = storage.poi[id].position}
	local numReachablePoi = 0
	
	
	for i, reachablePoi in pairs(poi.reachablePoi) do
		numReachablePoi = numReachablePoi + 1
		local otherPoi = reachablePoi[#reachablePoi]
		rendering.draw_circle{surface = game.surfaces[1], color = {0.2, 1, 0.2}, radius = 6, filled = true, time_to_live = ttl,	target = otherPoi.position}
		rendering.draw_text{text = i, color = {0.5, 0.5, 0.5}, time_to_live = ttl, scale = 30, surface = game.surfaces[1], target = otherPoi.position}
		for n, waypoint in pairs(reachablePoi) do
			rendering.draw_circle{surface = game.surfaces[1], color = {0.2, 0.2, 1}, radius = 3, filled = true, time_to_live = ttl, target = waypoint.position}
		end
	end
	
	game.print("POI " .. id .. " [gps=" .. storage.poi[id].position.x .. "," .. storage.poi[id].position.y .. "] " .. numReachablePoi .. " connections")
end


function debugPoiTraverse(poi, otherPoi, spiderCommuteEndpoint)
	-- Expects two poi IDs, and optionally a spider commute endpoint ID that is 10 or less
	-- For example debugPoiTraverse(11, 12, 1) shows the route POI 11 to POI 12 with traversal lines leading back to commute endpoint 1
	-- debugPoiTraverse(11, 12) shows all traversal lines on this route to all 10 spider commute endpoints
	
	local waypoints = storage.poi[poi].reachablePoi[otherPoi]
	if not waypoints then
		game.player.print("No route found from POI " .. poi .. " to POI " .. otherPoi)
		return
	end
	
	for id, waypoint in pairs(waypoints) do
		if spiderCommuteEndpoint then
			if waypoint.traversable[spiderCommuteEndpoint] then
				rendering.draw_line{surface = game.surfaces[1], from = waypoint.position, to = storage.poi[spiderCommuteEndpoint].position, color = {0, 1, 0}, width = 2, time_to_live = 5000}
			else
				rendering.draw_line{surface = game.surfaces[1], from = waypoint.position, to = storage.poi[spiderCommuteEndpoint].position, color = {0, 0, 1}, width = 2, time_to_live = 5000}
			end
		else
			for endpoint = 1, 10 do
				if waypoint.traversable[endpoint] then
					rendering.draw_line{surface = game.surfaces[1], from = waypoint.position, to = storage.poi[endpoint].position, color = {0, 1, 0}, width = 2, time_to_live = 5000}
				else
					rendering.draw_line{surface = game.surfaces[1], from = waypoint.position, to = storage.poi[endpoint].position, color = {0, 0, 1}, width = 2, time_to_live = 5000}
				end
			end
		end
	end
end


function tableToString(t)
	local text = "{"
	for id, entry in pairs(t) do
		-- Used for debugging to see which line number the table got screwed up on
		-- text = text .. "\n"
		if type(id) == "number" then
			text = text .. "[" .. id .. "]="
		else
			text = text .. id .. "="
		end
		if type(entry) == "table" then
			text = text .. tableToString(entry)
		elseif type(entry) == "boolean" then
			if entry then
				text = text .. "true,"
			else
				text = text .. "false,"
			end
		elseif type(entry) == "number" then
			text = text .. entry .. ","
		else
			text = text .. "\"" .. entry .. "\","
		end
	end
	if #text > 1 then -- Only trim the comma if the table was not empty
		text = string.sub(text, 1, #text - 1)
	end
	text = text .. "},"
	return text
end


function showTable(t)
	for id, entry in pairs(t) do
		if type(entry) == "table" then
			game.player.print(id .. " = table")
		elseif type(entry) == "boolean" then
			if entry then
				game.player.print(id .. " = true")
			else
				game.player.print(id .. " = false")
			end
		else
			game.player.print(id .. " = " .. entry)
		end
	end
end


function enableFirstSpiderTech()
	-- Enable technologies that would typically be available when players encounter the first spider.  For testing only.
	game.forces["player"].technologies["military"].researched = true
	
	game.forces["player"].technologies["weapon-shooting-speed-1"].researched = true
	game.forces["player"].technologies["weapon-shooting-speed-2"].researched = true
	game.forces["player"].technologies["weapon-shooting-speed-3"].researched = true
	
	game.forces["player"].technologies["physical-projectile-damage-1"].researched = true
	game.forces["player"].technologies["physical-projectile-damage-2"].researched = true
	game.forces["player"].technologies["physical-projectile-damage-3"].researched = true

	game.forces["player"].technologies["refined-flammables-1"].researched = true
	game.print("First Spider technologies unlocked")
end


function enableSecondSpiderTech()
	-- Enable technologies that would typically be available when players encounter the second spider.  For testing only.
	game.forces["player"].technologies["steel-processing"].researched = true
	game.forces["player"].technologies["logistic-science-pack"].researched = true
	
	game.forces["player"].technologies["military-2"].researched = true
	
	
	
	game.forces["player"].technologies["weapon-shooting-speed-4"].researched = true
	game.forces["player"].technologies["physical-projectile-damage-4"].researched = true
	
	game.forces["player"].technologies["stronger-explosives-1"].researched = true
	game.forces["player"].technologies["stronger-explosives-2"].researched = true
	
	game.forces["player"].technologies["refined-flammables-2"].researched = true
	game.print("Second Spider technologies unlocked")
end


function enforcePollutionBorder()
	-- Not used right now.  Old method of moving pollution.
	local westBorder = -96
	local eastBorder = 95
	local northBorder = -14
	local southBorder = 13
	for chunkX = westBorder, eastBorder do
		-- Move pollution at the bottom edge up
		movePollutionX(chunkX, southBorder, -1)
		
		-- Move pollution at the top edge down
		movePollutionX(chunkX, northBorder, 1)
	end
	for chunkY = northBorder, southBorder do
		-- Move pollution at the east edge west
		movePollutionY(chunkY, eastBorder, -1)
		
		-- Move pollution at the west edge east
		movePollutionY(chunkY, westBorder, 1)
	end
end


function stuck(spiderTag)

	local spider = {}
	if spiderTag and type(spiderTag) == "string" then
		if game.get_entity_by_tag(spiderTag) then
			spider = storage.enemySpiders[game.get_entity_by_tag(spiderTag).unit_number]
		else
			game.player.print(spiderTag .. " is dead or does not exist.")
			return
		end
	else
		game.player.print("You just entered some garbage.")
		return
	end
	
	game.player.print(
		"Position: " ..
		serpent.line(
			spider.spiderObject.position
		)
	)

	game.player.print(
		"Leg 1 position: " ..
		serpent.line(
			spider.spiderObject.get_spider_legs()[1].position
		)
	)

	game.player.print(
		"Autopilot destinations: " ..
		serpent.line(
			spider.spiderObject.autopilot_destinations
		)
	)

	game.player.print(
		"Stuck Time: " ..
		spider.stuckTime
	)

	if spider.pathRequestID then
		game.player.print(
			"pathRequestID: " ..
			spider.pathRequestID
		)
	else
		game.player.print("No path requested")
	end

	if storage.pathRequests[spider.pathRequestID] then
		game.player.print(
			"Path: " ..
			serpent.line(storage.pathRequests[spider.pathRequestID])
		)
	else
		game.player.print("Path: nil")
	end

end


function debugNukeDodge(forw, back, rocketPosition, rocketAngle, intersect, intersectToSpiderDistanceSq, rocketMaxRangeSq, runFrom, runTo)
	game.print("I saw an atomic-rocket")
	game.print("Forward  waypoint P1: " .. serpent.line(forw))
	game.print("Backward waypoint P2: " .. serpent.line(back))
	game.print("Rocket's position P3: " .. serpent.line(rocketPosition))
	game.print("Atomic Rocket Angle : " .. rocketAngle)
	
	game.print("Intersection predicted at: [gps=" .. intersect.x .. ", " .. intersect.y .. "]")
	
	game.print("intersectToSpiderDistanceSq: " .. intersectToSpiderDistanceSq)

	if intersectToSpiderDistanceSq < rocketMaxRangeSq then
		game.print("Using run-from-intercept strategy")
	else
		game.print("Using run-from-rocket strategy")
	end
	
	if runTo.x == back.x and runTo.y == back.y then
		game.print("I think it's safer to go backwards.")
	else
		game.print("I think it's safer to go forwards.")
	end
	
	game.print("Running from object at: " .. serpent.line(runFrom) .. " to waypoint at: " .. serpent.line(runTo))
end


function debugFindIntersection(forw, back, nuke, ix, iy)
	rendering.draw_line{surface = game.surfaces[1], from = forw, to = back,       color = {1, 1, 1}, width = 2, time_to_live = 1800}
	rendering.draw_line{surface = game.surfaces[1], from = nuke, to = {ix, iy},   color = {1, 1, 1}, width = 2, time_to_live = 1800}
	
	rendering.draw_circle{surface = game.surfaces[1], color = {0.5, 0.5, 0.5}, radius = 2, filled = true, time_to_live = 1800, target = forw}
	rendering.draw_circle{surface = game.surfaces[1], color = {0.5, 0.5, 0.5}, radius = 2, filled = true, time_to_live = 1800, target = back}
	rendering.draw_circle{surface = game.surfaces[1], color = {1, 0, 0},       radius = 2, filled = true, time_to_live = 1800, target = nuke}
	rendering.draw_circle{surface = game.surfaces[1], color = {0, 0, 1},       radius = 2, filled = true, time_to_live = 1800, target = {ix, iy}}
end
