-- This is a preset for Pyanodons mod set.
local Config = require 'config'
local ScenarioInfo = require 'features.gui.info'
local Event = require 'utils.event'

Config.redmew_surface.enabled = false
Config.rank_system.time_for_trust = 60 * 60 * 60
Config.train_saviour.enabled = false
Config.player_list.show_coin_column = false
Config.score.global_to_show = {
  'satellites-launched',
  'aliens-killed',
  'built-by-players',
  'built-by-robots',
  'trees-cut',
  'rocks-smashed',
  'kills-by-trains'
}

Config.market.enabled = false
Config.player_create.starting_items = {
  {name = 'stone-furnace', count = 1},
  {name = 'burner-mining-drill', count = 10},
  {name = 'raw-coal', count = 50}
}
if (mods or script.active_mods)["early_construction"] then
  table.insert(Config.player_create.starting_items, {name = 'early-construction-heavy-armor', count = 1})
  table.insert(Config.player_create.starting_items, {name = 'early-construction-equipment', count = 2})
end
Config.player_rewards.enabled = false
Config.redmew_qol.loaders = false

table.insert(Config.player_create.join_messages, 'Make sure to check out the added QoL mods!')

ScenarioInfo.set_map_name('Redmew - Pyanodons')
ScenarioInfo.set_map_description([[Welcome to the full Pyanodons Experience!

We hope you enjoy your stay
]])
ScenarioInfo.add_map_extra_info([[
A few extra rules before we start:
- Respect other peoples creations.
- Create an alternative before demolishing.
- Keep blueprint imports low. Part of the fun is finding solutions.
- Do not cover the map in a logistics network.

Tips for starting this map:
- All inserters have at least one filter slot
- An inserter set to blacklist moves everything but the items in the filter slots
- If you need help with the automated train system ask in chat or check the Discord for a short guide.
- Ash is plenty but try to store it.
- Early Construction Robots can only be handcrafted.
- Shift+F brings up an interface to search (Factory Search Mod by Xorimuth)

There are a lot more Quality of life mods, make sure to check mods page to find how to access
and use them. Also check the Shortcut Bar Menu with the 3 small dots. A lot of mods add buttons there.
]])
ScenarioInfo.set_new_info([[
]])

Event.on_init(function()
  --[[Use this to grant boni depending on the mod pack.
  If a lot items are added consider adding bag space.
  Default for ALL of them is ZERO.
  Modifiers are calculated as 1 + modifier. ]]
  game.forces.player.character_inventory_slots_bonus = 30
  game.forces.player.manual_mining_speed_modifier = 0
  game.forces.player.manual_crafting_speed_modifier = 0.5
  game.forces.player.character_running_speed_modifier = 0.25

  if (mods or script.active_mods)["early_construction"] then
    game.forces.player.technologies["early-construction-light-armor"].researched = true
  end
end)