local Event = require 'utils.event'

local function starts_with(str, pattern)
  return str:sub(1, #pattern) == pattern
end

Event.add(defines.events.on_research_finished, function(event)
  local tech = event.research
  if not (tech and tech.valid) then
    return
  end

  if not starts_with(tech.name, 'mining-productivity') then
    return
  end

  local force = tech.force
  force.mining_drill_productivity_bonus = 0
  force.worker_robots_storage_bonus = force.worker_robots_storage_bonus + 1

  game.print(table.concat({
    '[color=orange][Mining productivity][/color]',
    '➡',
    '[color=blue][Worker robots cargo size][/color]',
    '\nReplacing technology effects. New robots cargo capacity:',
    '[color=green][font=var]+'..force.worker_robots_storage_bonus..'[/font][/color]'
  }, '\t\t'))
end)
