
-- defines all ore patches to be generated. Add as many clusters as
-- needed. Clusters listed first have a higher placement priority over
-- the latter clusters
--
-- TODO update and document all configuration settings
--
-- noise types:
--   cluster: same as vanilla factorio generation
--   skip: skips this cluster
--   connected_tendril: long ribbons of ore
--   fragmented_tendril: long ribbons of ore that occur when inside another
--       region of ribbons
--
-- noise source types and configurations
--   perlin: same as vanilla factorio generation
--     variance: increase to make patches closer together and smaller
--         note that this is the inverse of the cluster_mode variance
--     threshold: increase to shrink size of patches
--   simplex: similar to perlin
--   zero: does nothing with this source
--   one: adds the weight directly to the noise calculation
return {

{
        yield=12,
        min_distance=10,
        max_distance=15,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.3,
            sources = {
                {variance=20, weight = 1, offset = 740, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 1000,
        },
        distances = {
            ['iron-ore']        = 10,
        }, 
},
{
        yield=12,
        min_distance=10,
        max_distance=15,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.3,
            sources = {
                {variance=20, weight = 1, offset = 487, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 1000,
        },
        distances = {
            ['copper-ore']        = 10,
        }, 
},
{
        yield=12,
        min_distance=10,
        max_distance=15,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.3,
            sources = {
                {variance=20, weight = 1, offset = 17, type="perlin"},
            }
        },
        weights = {
            ['coal']        = 1000,
        },
        distances = {
            ['coal']        = 10,
        }, 
},
{
        yield=6,
        min_distance=20,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 927, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 666,
            ['iron-ore']  = 334,
        },
        distances = {
            ['stone']        = 20,
            ['iron-ore']        = 20,
        }, 
},
{
        yield=6,
        min_distance=20,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 438, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 666,
            ['copper-ore']  = 334,
        },
        distances = {
            ['stone']        = 20,
            ['copper-ore']        = 20,
        }, 
},
{
        yield=6,
        min_distance=20,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 504, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 666,
            ['coal']  = 334,
        },
        distances = {
            ['stone']        = 20,
            ['coal']        = 20,
        }, 
},
{
        yield=3.6,
        min_distance=100,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 178, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 200,
            ['iron-ore']  = 800,
        },
        distances = {
            ['stone']        = 100,
            ['iron-ore']        = 100,
        }, 
},
{
        yield=3.6,
        min_distance=100,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 502, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 200,
            ['copper-ore']  = 800,
        },
        distances = {
            ['stone']        = 100,
            ['copper-ore']        = 100,
        }, 
},
{
        yield=3.6,
        min_distance=100,
        max_distance=9999,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=30, weight = 1, offset = 173, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 200,
            ['coal']  = 800,
        },
        distances = {
            ['stone']        = 100,
            ['coal']        = 100,
        }, 
},

{
        yield=0.6,
        min_distance=800,
        max_distance=1000,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 588, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 260,
            ['stone']  = 700,
            ['uranium-ore']    = 30,
        },
        distances = {
            ['iron-ore']        = 800,
            ['stone']        = 800,
            ['uranium-ore']        = 800,
        }, 
},
{
        yield=4.8,
        min_distance=50,
        max_distance=100,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 892, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 260,
            ['iron-ore']  = 700,
            ['tin-ore']    = 30,
        },
        distances = {
            ['copper-ore']        = 50,
            ['iron-ore']        = 50,
            ['tin-ore']        = 50,
        }, 
},
{
        yield=4.8,
        min_distance=50,
        max_distance=100,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 275, type="perlin"},
            }
        },
        weights = {
            ['coal']        = 260,
            ['copper-ore']  = 700,
            ['lead-ore']    = 30,
        },
        distances = {
            ['coal']        = 50,
            ['copper-ore']        = 50,
            ['lead-ore']        = 50,
        }, 
},
{
        yield=3,
        min_distance=100,
        max_distance=250,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 461, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 260,
            ['stone']  = 700,
            ['quartz']    = 30,
        },
        distances = {
            ['iron-ore']        = 100,
            ['stone']        = 100,
            ['quartz']        = 100,
        }, 
},
{
        yield=1.2,
        min_distance=600,
        max_distance=700,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 835, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 260,
            ['iron-ore']  = 700,
            ['silver-ore']    = 30,
        },
        distances = {
            ['copper-ore']        = 600,
            ['iron-ore']        = 600,
            ['silver-ore']        = 600,
        }, 
},
{
        yield=3,
        min_distance=500,
        max_distance=600,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 939, type="perlin"},
            }
        },
        weights = {
            ['coal']        = 260,
            ['copper-ore']  = 700,
            ['zinc-ore']    = 30,
        },
        distances = {
            ['coal']        = 500,
            ['copper-ore']        = 500,
            ['zinc-ore']        = 500,
        }, 
},
{
        yield=0.6,
        min_distance=400,
        max_distance=800,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 731, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 260,
            ['stone']  = 700,
            ['gold-ore']    = 30,
        },
        distances = {
            ['iron-ore']        = 400,
            ['stone']        = 400,
            ['gold-ore']        = 400,
        }, 
},
{
        yield=1.8,
        min_distance=200,
        max_distance=300,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 155, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 260,
            ['iron-ore']  = 700,
            ['bauxite-ore']    = 30,
        },
        distances = {
            ['copper-ore']        = 200,
            ['iron-ore']        = 200,
            ['bauxite-ore']        = 200,
        }, 
},
{
        yield=1.2,
        min_distance=1000,
        max_distance=1200,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 590, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 260,
            ['copper-ore']  = 700,
            ['rutile-ore']    = 30,
        },
        distances = {
            ['stone']        = 1000,
            ['copper-ore']        = 1000,
            ['rutile-ore']        = 1000,
        }, 
},
{
        yield=0.6,
        min_distance=1200,
        max_distance=1500,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 413, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 260,
            ['stone']  = 700,
            ['tungsten-ore']    = 30,
        },
        distances = {
            ['iron-ore']        = 1200,
            ['stone']        = 1200,
            ['tungsten-ore']        = 1200,
        }, 
},
{
        yield=1.8,
        min_distance=300,
        max_distance=600,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 954, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 260,
            ['iron-ore']  = 700,
            ['nickel-ore']    = 30,
        },
        distances = {
            ['copper-ore']        = 300,
            ['iron-ore']        = 300,
            ['nickel-ore']        = 300,
        }, 
},
{
        yield=1.8,
        min_distance=500,
        max_distance=650,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 532, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 260,
            ['copper-ore']  = 700,
            ['cobalt-ore']    = 30,
        },
        distances = {
            ['stone']        = 500,
            ['copper-ore']        = 500,
            ['cobalt-ore']        = 500,
        }, 
},
{
        yield=0.3,
        min_distance=200,
        max_distance=400,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 127, type="perlin"},
            }
        },
        weights = {
            ['iron-ore']        = 260,
            ['stone']  = 700,
            ['sulfur']    = 30,
        },
        distances = {
            ['iron-ore']        = 200,
            ['stone']        = 200,
            ['sulfur']        = 200,
        }, 
},
{
        yield=3,
        min_distance=800,
        max_distance=1500,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.5,
            sources = {
                {variance=15, weight = 1, offset = 356, type="perlin"},
            }
        },
        weights = {
            ['copper-ore']        = 290,
            ['iron-ore']  = 700,
            ['gem-ore']    = 7,
        },
        distances = {
            ['copper-ore']        = 800,
            ['iron-ore']        = 800,
            ['gem-ore']        = 800,
        }, 
},
{
        yield=4,
        min_distance=200,
        max_distance=400,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.6,
            sources = {
                {variance=20, weight = 1, offset = 347, type="perlin"},
            }
        },
        weights = {
            ['crude-oil']        = 1000,
        },
        distances = {
            ['crude-oil']        = 200,
        }, 
},
{
        yield=1,
        min_distance=400,
        max_distance=600,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.6,
            sources = {
                {variance=20, weight = 1, offset = 887, type="perlin"},
            }
        },
        weights = {
            ['lithia-water']        = 1000,
        },
        distances = {
            ['lithia-water']        = 400,
        }, 
},




{
        yield=9.6,
        min_distance=100,
        max_distance=600,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 130, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['copper-ore']  = 167,
            ['tin-ore']    = 333,
        },
        distances = {
            ['stone']        = 100,
            ['copper-ore']        = 100,
            ['tin-ore']        = 100,
        }, 
},
{
        yield=9.6,
        min_distance=100,
        max_distance=600,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 224, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['copper-ore']  = 167,
            ['lead-ore']    = 333,
        },
        distances = {
            ['stone']        = 100,
            ['copper-ore']        = 100,
            ['lead-ore']        = 100,
        }, 
},
{
        yield=6,
        min_distance=250,
        max_distance=750,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 525, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['tin-ore']  = 167,
            ['quartz']    = 333,
        },
        distances = {
            ['stone']        = 250,
            ['tin-ore']        = 250,
            ['quartz']        = 250,
        }, 
},
{
        yield=3.6,
        min_distance=300,
        max_distance=800,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 726, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['coal']  = 167,
            ['bauxite-ore']    = 333,
        },
        distances = {
            ['stone']        = 300,
            ['coal']        = 300,
            ['bauxite-ore']        = 300,
        }, 
},
{
        yield=0.6,
        min_distance=400,
        max_distance=900,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 453, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['bauxite-ore']  = 167,
            ['sulfur']    = 333,
        },
        distances = {
            ['stone']        = 400,
            ['bauxite-ore']        = 400,
            ['sulfur']        = 400,
        }, 
},
{
        yield=6,
        min_distance=600,
        max_distance=1100,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 630, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['iron-ore']  = 167,
            ['zinc-ore']    = 333,
        },
        distances = {
            ['stone']        = 600,
            ['iron-ore']        = 600,
            ['zinc-ore']        = 600,
        }, 
},
{
        yield=3.6,
        min_distance=600,
        max_distance=1100,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 940, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['zinc-ore']  = 167,
            ['nickel-ore']    = 333,
        },
        distances = {
            ['stone']        = 600,
            ['zinc-ore']        = 600,
            ['nickel-ore']        = 600,
        }, 
},
{
        yield=3.6,
        min_distance=650,
        max_distance=1150,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 723, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['quartz']  = 167,
            ['cobalt-ore']    = 333,
        },
        distances = {
            ['stone']        = 650,
            ['quartz']        = 650,
            ['cobalt-ore']        = 650,
        }, 
},
{
        yield=2.4,
        min_distance=700,
        max_distance=1200,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 688, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['zinc-ore']  = 167,
            ['silver-ore']    = 333,
        },
        distances = {
            ['stone']        = 700,
            ['zinc-ore']        = 700,
            ['silver-ore']        = 700,
        }, 
},
{
        yield=1.2,
        min_distance=800,
        max_distance=1300,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 592, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['cobalt-ore']  = 167,
            ['gold-ore']    = 333,
        },
        distances = {
            ['stone']        = 800,
            ['cobalt-ore']        = 800,
            ['gold-ore']        = 800,
        }, 
},
{
        yield=2.4,
        min_distance=1200,
        max_distance=1700,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 13, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['lead-ore']  = 167,
            ['rutile-ore']    = 333,
        },
        distances = {
            ['stone']        = 1200,
            ['lead-ore']        = 1200,
            ['rutile-ore']        = 1200,
        }, 
},
{
        yield=1.2,
        min_distance=1500,
        max_distance=2000,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 451, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['iron-ore']  = 167,
            ['tungsten-ore']    = 333,
        },
        distances = {
            ['stone']        = 1500,
            ['iron-ore']        = 1500,
            ['tungsten-ore']        = 1500,
        }, 
},
{
        yield=6,
        min_distance=1500,
        max_distance=2000,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 971, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['sulfur']  = 167,
            ['gem-ore']    = 333,
        },
        distances = {
            ['stone']        = 1500,
            ['sulfur']        = 1500,
            ['gem-ore']        = 1500,
        }, 
},
{
        yield=6,
        min_distance=1000,
        max_distance=1500,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.45,
            sources = {
                {variance=30, weight = 1, offset = 739, type="perlin"},
            }
        },
        weights = {
            ['stone']        = 500,
            ['bauxite-ore']  = 167,
            ['uranium-ore']    = 333,
        },
        distances = {
            ['stone']        = 1000,
            ['bauxite-ore']        = 1000,
            ['uranium-ore']        = 1000,
        }, 
},
{
        yield=15,
        min_distance=600,
        max_distance=1100,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.6,
            sources = {
                {variance=30, weight = 1, offset = 348, type="perlin"},
            }
        },
        weights = {
            ['lithia-water']        = 1000,
        },
        distances = {
            ['lithia-water']        = 600,
        }, 
},
{
        yield=20,
        min_distance=400,
        max_distance=900,
        distance_richness=7,
        noise_settings = {
            type = "cluster",
            threshold = 0.6,
            sources = {
                {variance=30, weight = 1, offset = 208, type="perlin"},
            }
        },
        weights = {
            ['crude-oil']        = 1000,
        },
        distances = {
            ['crude-oil']        = 400,
        }, 
},




}
